const request = require('supertest');
const app = require('../app');

describe('App', () => {
  it('should export an express app', () => {
    expect(app).toBeDefined();
    expect(typeof app.listen).toBe('function');
  });

  it('should return 404 for unknown routes', async () => {
    const res = await request(app).get('/api/unknown-route-xyz');
    expect(res.statusCode).toBe(404);
    // Check the response body - in development mode it includes more info
    expect(res.body.status).toBe('fail');
  });
});

